(SELECT profiles.realname, 'SUM' thetext, '2017-05-17' bug_when, SUM(ld.work_time) work_time, '' bug_name
FROM longdescs ld
LEFT OUTER JOIN profiles  ON  ld.who = profiles.userid
WHERE
  ld.bug_when >= '2017-05-17' AND ld.bug_when < '2017-05-18'
GROUP BY profiles.realname
) UNION ALL (
SELECT profiles.realname, ld.thetext, ld.bug_when, ld.work_time, bugs.short_desc bug_name
FROM longdescs ld
LEFT OUTER JOIN profiles  ON  ld.who = profiles.userid
LEFT OUTER JOIN bugs      ON  ld.bug_id = bugs.bug_id
WHERE
  ld.bug_when >= '2017-05-17' AND ld.bug_when < '2017-05-18'
ORDER BY profiles.realname, ld.bug_when, ld.work_time)

---

SELECT profiles.realname, fielddefs.description, ba.bug_when, ba.added AS work_time, bugs.short_desc
FROM bugs_activity ba
LEFT OUTER JOIN profiles  ON  ba.who = profiles.userid
LEFT OUTER JOIN bugs      ON  ba.bug_id = bugs.bug_id
LEFT OUTER JOIN fielddefs ON  ba.fieldid = fielddefs.id
WHERE
  -- ba.fieldid = 47 AND -- hours added
  ba.bug_when >= '2017-05-17' AND ba.bug_when < '2017-05-18'
GROUP BY profiles.realname, fielddefs.description, ba.bug_when, ba.added, bugs.short_desc
ORDER BY profiles.realname, ba.bug_when, ba.added


----
